{{-- resources/views/talenta/employees/index.blade.php --}}
@extends('layouts.app')
@section('title','Data Karyawan (Talenta)')
@section('page-title','Data Karyawan (Talenta)')

@section('content')
<div class="bg-white p-4 rounded-xl shadow">
  @if ($errors->any())
    <div class="mb-3 bg-red-50 text-red-700 p-3 rounded">
      @foreach ($errors->all() as $e) <div>{{ $e }}</div> @endforeach
    </div>
  @endif

  {{-- Filter --}}
  <form method="GET" class="mb-4 grid grid-cols-1 md:grid-cols-6 gap-3 items-end">
    <div>
      <label class="block text-xs text-gray-500 mb-1">Limit</label>
      <input type="number" name="limit" value="{{ $limit }}" class="border rounded px-3 py-2 w-full">
    </div>
    <div>
      <label class="block text-xs text-gray-500 mb-1">Page</label>
      <input type="number" name="page" value="{{ $page }}" class="border rounded px-3 py-2 w-full">
    </div>
    <div class="md:col-span-2">
      <label class="block text-xs text-gray-500 mb-1">Search (nama/email/id)</label>
      <input type="text" name="search" value="{{ $search }}" placeholder="Nama / Email / Employee ID"
             class="border rounded px-3 py-2 w-full">
    </div>
    <div>
      <label class="block text-xs text-gray-500 mb-1">Company ID (opsional)</label>
      <input type="text" name="company_id" value="{{ request('company_id','') }}" class="border rounded px-3 py-2 w-full">
    </div>
    <label class="inline-flex items-center gap-2">
      <input type="checkbox" name="only_active" value="1" {{ request()->boolean('only_active') ? 'checked' : '' }}>
      <span class="text-sm text-gray-700">Only Active</span>
    </label>

    <div>
      <label class="block text-xs text-gray-500 mb-1">User ID (tembak detail)</label>
      <input type="text" name="user_id" value="{{ request('user_id','') }}" placeholder="3878753"
             class="border rounded px-3 py-2 w-full">
    </div>
    <div>
      <label class="block text-xs text-gray-500 mb-1">Employee ID</label>
      <input type="text" name="employee_id" value="{{ request('employee_id','') }}" placeholder="KM10008048"
             class="border rounded px-3 py-2 w-full">
    </div>
    <div class="md:col-span-2">
      <label class="block text-xs text-gray-500 mb-1">Email</label>
      <input type="email" name="email" value="{{ request('email','') }}" placeholder="nama@domain.com"
             class="border rounded px-3 py-2 w-full">
    </div>

    <div class="md:col-span-6 flex items-center gap-2">
      <button class="px-4 py-2 rounded bg-slate-700 text-white">Reload</button>
      <a href="{{ route('talenta.employees.index') }}" class="px-4 py-2 rounded border">Reset</a>
    </div>
  </form>

  @php
    // helper ambil field
    $gv = function(array $row, array $alts, $default='') {
      foreach ($alts as $k) {
        $v = data_get($row, $k);
        if (!is_null($v) && $v!=='') return $v;
      }
      return $default;
    };
    // format tanggal
    $fd = function($dateStr) {
      if (!$dateStr) return '';
      try { $dt = \Carbon\Carbon::parse($dateStr); return $dt->format('d M Y'); }
      catch (\Throwable $e) { return $dateStr; }
    };
  @endphp

  <div class="overflow-x-auto">
    <table class="min-w-[1200px] w-full text-sm border">
      <thead class="bg-slate-50">
        <tr class="text-left border-b">
          <th class="py-2 px-3">Employee name</th>
          <th class="py-2 px-3">Employee Id</th>
          <th class="py-2 px-3">Branch</th>
          <th class="py-2 px-3">Organization</th>
          <th class="py-2 px-3">Job position</th>
          <th class="py-2 px-3">Job level</th>
          <th class="py-2 px-3">Employment status</th>
          <th class="py-2 px-3">Join date</th>
          <th class="py-2 px-3">End date</th>
          <th class="py-2 px-3">Sign date</th>
          <th class="py-2 px-3">Resign date</th>
          <th class="py-2 px-3">Barcode</th>
          <th class="py-2 px-3">Email</th>
          <th class="py-2 px-3">Birth date</th>
          <th class="py-2 px-3">Birth place</th>
          <th class="py-2 px-3">Address</th>
          <th class="py-2 px-3">Phone number</th>
          <th class="py-2 px-3">Religion</th>
          <th class="py-2 px-3">Gender</th>
          <th class="py-2 px-3">Marital status</th>
        </tr>
      </thead>
      <tbody>
        @php $rows = $items ?? []; @endphp

        @forelse($rows as $it)
          @php
            // Personal
            $first   = $gv($it, ['personal.first_name','personal.firstname','first_name']);
            $last    = $gv($it, ['personal.last_name','personal.lastname','last_name']);
            $name    = trim($first.' '.$last) ?: $gv($it, ['personal.full_name','full_name','name']);
            $emailV  = $gv($it, ['personal.email','email']);
            $mobile  = $gv($it, ['personal.mobile_phone','personal.phone','phone']);
            $genderV = $gv($it, ['personal.gender','gender']);
            $relig   = $gv($it, ['personal.religion','religion']);
            $married = $gv($it, ['personal.marital_status','marital_status']);
            $bdate   = $fd($gv($it, ['personal.birth_date','personal.birthdate','birth_date']));
            $bplace  = $gv($it, ['personal.birth_place','personal.birthplace','birth_place']);
            $addr    = $gv($it, ['personal.address','personal.address_full','personal.addresses.0.full','personal.addresses.0.address','address']);

            // Employment / Organization
            $empId   = $gv($it, ['employment.employee_id','employment.employee_number','employee_id','employee_number','employee_no','user_id']);
            $branch  = $gv($it, ['employment.branch.name','employment.branch','organization.branch.name','organization.branch']);
            $org     = $gv($it, ['employment.organization.name','organization.name','company.name']);
            $pos     = $gv($it, ['employment.position.name','employment.job_position','employment.job_position.name','employment.job_title','position']);
            $level   = $gv($it, ['employment.level.name','employment.job_level','employment.job_level.name','job_level']);
            $statusE = $gv($it, ['employment.employment_status','employment.status','status']);

            $join    = $fd($gv($it, ['employment.join_date','join_date']));
            $end     = $fd($gv($it, ['employment.end_date','end_date']));
            $sign    = $fd($gv($it, ['employment.sign_date','sign_date']));
            $resign  = $fd($gv($it, ['employment.resign_date','resign_date']));
            $barcode = $gv($it, ['personal.barcode','employment.barcode','barcode']);

            // Search sisi view (tetap dipakai saat hasil dari list biasa)
            $keyword = strtolower($search ?? '');
            $match = true;
            if ($keyword) {
              $hay = strtolower($name.' '.$emailV.' '.$empId);
              $match = str_contains($hay, $keyword);
            }
          @endphp

          @if($match)
            <tr class="border-b hover:bg-slate-50">
              <td class="py-2 px-3 font-medium">{{ $name }}</td>
              <td class="py-2 px-3">{{ $empId }}</td>
              <td class="py-2 px-3">{{ $branch }}</td>
              <td class="py-2 px-3">{{ $org }}</td>
              <td class="py-2 px-3">{{ $pos }}</td>
              <td class="py-2 px-3">{{ $level }}</td>
              <td class="py-2 px-3">{{ $statusE }}</td>
              <td class="py-2 px-3">{{ $join ?: '-' }}</td>
              <td class="py-2 px-3">{{ $end ?: '-' }}</td>
              <td class="py-2 px-3">{{ $sign ?: '-' }}</td>
              <td class="py-2 px-3">{{ $resign ?: '-' }}</td>
              <td class="py-2 px-3">{{ $barcode ?: '-' }}</td>
              <td class="py-2 px-3">{{ $emailV }}</td>
              <td class="py-2 px-3">{{ $bdate }}</td>
              <td class="py-2 px-3">{{ $bplace }}</td>
              <td class="py-2 px-3">{{ $addr }}</td>
              <td class="py-2 px-3">{{ $mobile }}</td>
              <td class="py-2 px-3">{{ $relig }}</td>
              <td class="py-2 px-3">{{ $genderV }}</td>
              <td class="py-2 px-3">{{ $married }}</td>
            </tr>
          @endif
        @empty
          <tr><td colspan="20" class="py-6 text-center text-gray-500">Tidak ada data.</td></tr>
        @endforelse
      </tbody>
    </table>
  </div>

  {{-- Pagination --}}
  @php
    $pg   = $pagination ?? [];
    $cur  = (int)($pg['current_page'] ?? $page ?? 1);
    $last = (int)($pg['last_page'] ?? 1);
    $start = max(1, $cur - 2);
    $end   = min($last, $cur + 2);
    $qs    = request()->except('page');
  @endphp

  @if($last > 1)
    <div class="mt-4 flex flex-wrap items-center gap-2">
      <a href="{{ route('talenta.employees.index', array_merge($qs, ['page'=>1,'limit'=>$limit])) }}" class="px-3 py-1.5 rounded border {{ $cur==1 ? 'pointer-events-none opacity-50' : 'hover:bg-slate-50' }}">« First</a>
      <a href="{{ route('talenta.employees.index', array_merge($qs, ['page'=>max(1,$cur-1),'limit'=>$limit])) }}" class="px-3 py-1.5 rounded border {{ $cur==1 ? 'pointer-events-none opacity-50' : 'hover:bg-slate-50' }}">‹ Prev</a>

      @for($i=$start; $i<=$end; $i++)
        <a href="{{ route('talenta.employees.index', array_merge($qs, ['page'=>$i,'limit'=>$limit])) }}"
           class="px-3 py-1.5 rounded border {{ $i==$cur ? 'bg-slate-800 text-white border-slate-800' : 'hover:bg-slate-50' }}">
           {{ $i }}
        </a>
      @endfor

      <a href="{{ route('talenta.employees.index', array_merge($qs, ['page'=>min($last,$cur+1),'limit'=>$limit])) }}" class="px-3 py-1.5 rounded border {{ $cur==$last ? 'pointer-events-none opacity-50' : 'hover:bg-slate-50' }}">Next ›</a>
      <a href="{{ route('talenta.employees.index', array_merge($qs, ['page'=>$last,'limit'=>$limit])) }}" class="px-3 py-1.5 rounded border {{ $cur==$last ? 'pointer-events-none opacity-50' : 'hover:bg-slate-50' }}">Last »</a>

      <div class="text-sm text-gray-600 ml-2">
        Page {{ $cur }} of {{ $last }} | Total: {{ $pg['total'] ?? '—' }}
      </div>
    </div>
  @elseif(!empty($pagination))
    <div class="mt-4 text-xs text-gray-600">
      Page {{ $pagination['current_page'] ?? '?' }} of {{ $pagination['last_page'] ?? '?' }} |
      Total: {{ $pagination['total'] ?? '?' }}
    </div>
  @endif

  <details class="mt-6">
    <summary class="cursor-pointer text-slate-600">Lihat RAW JSON</summary>
    <pre class="text-xs bg-slate-50 p-3 rounded overflow-auto">{{ json_encode($raw ?? [], JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE) }}</pre>
  </details>
</div>
@endsection
